#!/bin/bash
exp_id=$1
num_shadow=$2

BUFFER_PATH="buffer/mtt"
DATA_PATH="datasets"
SAVE_PATH="exps/mtt_real_init/syn_img"
LIRA_PATH="exps/mtt_real_init/lira"

python src/dd/distill_mtt_tesla.py \
    --dataset CIFAR10 \
    --ipc 1000 \
    --syn_steps 100 \
    --expert_epochs 2 \
    --max_start_epoch 40 \
    --zca \
    --pix_init real \
    --lr_img 100 \
    --lr_lr 1e-06 \
    --lr_teacher 0.01 \
    --buffer_path $BUFFER_PATH \
    --data_path $DATA_PATH \
    --epoch_eval_train 300 \
    --batch_syn 200 \
    --Iteration 1500 \
    --eval_it 100 \
    --num_eval 1 \
    --save_path $SAVE_PATH \
    --lira_path $LIRA_PATH \
    --exp_id $exp_id \
    --num_shadow $num_shadow \
    --num_canaries 500 > logs/mtt/mtt_real_init_$exp_id.log
